#!/usr/bin/env python3
"""
Simple script to run the Smart Image Compressor application.
This script can be used to test the application before building the executable.
"""

import sys
import os

# Add the current directory to the Python path
current_dir = os.path.dirname(os.path.abspath(__file__))
sys.path.insert(0, current_dir)

try:
    from image_compressor import ImageCompressorApp
    from PyQt5.QtWidgets import QApplication
    
    if __name__ == "__main__":
        app = QApplication(sys.argv)
        window = ImageCompressorApp()
        window.show()
        sys.exit(app.exec_())
        
except ImportError as e:
    print(f"Error importing required modules: {e}")
    print("Please make sure all dependencies are installed:")
    print("pip install PyQt5 Pillow")
    input("Press Enter to exit...")
    sys.exit(1)
except Exception as e:
    print(f"Error running application: {e}")
    input("Press Enter to exit...")
    sys.exit(1)