import os
import sys
from PyQt5.QtGui import QIcon, QPixmap, QPainter, QColor, QFont, QPen, QBrush
from PyQt5.QtCore import Qt, QRect, QSize

# Make sure we have the required packages
try:
    from PIL import Image
except ImportError:
    import subprocess
    print("Installing Pillow (PIL) for icon conversion...")
    subprocess.check_call([sys.executable, "-m", "pip", "install", "Pillow"])
    from PIL import Image

def create_email_icon():
    """Create a simple email icon"""
    print("Creating email icon...")
    
    # Create a 256x256 icon (Windows recommends multiple sizes, but we'll use one for simplicity)
    icon_size = 256
    
    # Create a QPixmap to draw on
    pixmap = QPixmap(icon_size, icon_size)
    pixmap.fill(Qt.transparent)
    
    painter = QPainter(pixmap)
    painter.setRenderHint(QPainter.Antialiasing)
    
    # Draw email envelope
    painter.setPen(QPen(QColor(50, 50, 50), 3))
    painter.setBrush(QBrush(QColor(42, 130, 218)))  # Blue color
    
    # Envelope body
    envelope_rect = QRect(20, 48, icon_size - 40, icon_size - 96)
    painter.drawRoundedRect(envelope_rect, 10, 10)
    
    # Envelope flap
    painter.setBrush(QBrush(QColor(35, 107, 178)))  # Darker blue for flap
    painter.drawPolygon([
        envelope_rect.topLeft() + QSize(0, 0),
        envelope_rect.topRight() + QSize(0, 0),
        QSize(icon_size // 2, envelope_rect.top() + envelope_rect.height() // 2)
    ])
    
    # Draw @ symbol for email
    painter.setPen(QPen(QColor(255, 255, 255), 4))
    font = QFont("Arial", 70, QFont.Bold)
    painter.setFont(font)
    painter.drawText(envelope_rect, Qt.AlignCenter, "@")
    
    painter.end()
    
    # Save as .ico format
    temp_png = "temp_icon.png"
    ico_file = "email_icon.ico"
    
    pixmap.save(temp_png)
    
    # Convert PNG to ICO using PIL
    img = Image.open(temp_png)
    img.save(ico_file, format='ICO')
    
    # Clean up temporary PNG
    os.remove(temp_png)
    
    print(f"Icon created successfully: {ico_file}")
    return ico_file

if __name__ == "__main__":
    create_email_icon()
    print("You can now use this icon with PyInstaller to build your executable.")
    input("Press Enter to exit...")