import os
import sys
import subprocess
import shutil

def main():
    print("=== HTML Email Sender - Build Script ===")
    print("This script will build an executable from your Python application")
    
    # Check if PyInstaller is installed
    try:
        import PyInstaller
        print("PyInstaller is already installed.")
    except ImportError:
        print("PyInstaller is not installed. Installing now...")
        subprocess.check_call([sys.executable, "-m", "pip", "install", "pyinstaller"])
        print("PyInstaller installed successfully.")

    # Check if other required packages are installed
    required_packages = ["PyQt5", "cryptography"]
    for package in required_packages:
        try:
            __import__(package)
            print(f"{package} is already installed.")
        except ImportError:
            print(f"{package} is not installed. Installing now...")
            subprocess.check_call([sys.executable, "-m", "pip", "install", package])
            print(f"{package} installed successfully.")

    # Check if the main script exists
    script_name = "email_sender.py"
    if not os.path.isfile(script_name):
        print(f"Error: {script_name} not found in the current directory.")
        script_name = input("Enter the name of your main script file: ")
        if not os.path.isfile(script_name):
            print(f"Error: {script_name} not found. Exiting.")
            return

    # Create build directory
    build_dir = "build"
    if not os.path.exists(build_dir):
        os.makedirs(build_dir)
    
    # Build the executable
    print("\nBuilding executable... This might take a few minutes.")
    
    # Prepare PyInstaller command
    pyinstaller_cmd = [
        "pyinstaller",
        "--onefile",  # Create a single executable
        "--windowed",  # Windows application without console
        "--name", "HTML_Email_Sender",
        "--clean",  # Clean PyInstaller cache
    ]
    
    # Add icon if it exists
    if os.path.exists("email_icon.ico"):
        pyinstaller_cmd.append("--icon=email_icon.ico")
    
    # Add the script name
    pyinstaller_cmd.append(script_name)
    
    # Run PyInstaller
    subprocess.check_call(pyinstaller_cmd)
    
    print("\nBuild completed successfully!")
    
    # Copy the executable to a convenient location
    dist_dir = "dist"
    exe_name = "HTML_Email_Sender.exe"
    exe_path = os.path.join(dist_dir, exe_name)
    
    if os.path.exists(exe_path):
        shutil.copy(exe_path, ".")
        print(f"\nThe executable has been created: {exe_name}")
        print("You can distribute this file to run the application on any Windows computer")
    else:
        print(f"Error: Executable {exe_path} not found.")

if __name__ == "__main__":
    try:
        main()
    except Exception as e:
        print(f"An error occurred: {e}")
    
    input("\nPress Enter to exit...")